	clear all
	close all
	clc
	% Half-band circulator-Tree Wave Digital Filter
	wsT = 0.556*pi
	Amin = 60;
	N = CA_ORDER_HB_Z(wsT, Amin)
	N = 11;			% We MUST select an odd order
	[G, Z, P, wcT, wsT, Amax, Amin] = CA_POLES_HB_Z(wsT, Amin, N)
 
	alfa = CT_TREE_WDF_LP(P)
	wT = linspace(0, pi, 512); 
	[s11, s21] = CT_TREE_WDF_LP_H(alfa, wT);
	Att = H_2_ATT(s21);
	subplot('position', [0.1 0.4 0.88 0.5]);
	PLOT_ATT_Z(wT, Att, pi, 80)
	
	figure(2)
	PLOT_PZ_Z(Z, P)
	
	
